/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.discount;

import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.discount.CalcDiscount;
import com.android.product.domain.model.ProductDto;
import com.customer.domain.use_case.DiscountBasedOnRowDetails;
import com.customer.domain.use_case.GetCustomerList;
import com.dto.CustomerDto;
import com.dto.MainGroupDto;
import com.dto.SideGroupDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class DiscountCommissionTools {
    private final TncJdbc jdbc;
    private final AInvoiceDto dto;
    private final String userMidManCode;

    public DiscountCommissionTools(DbConnection dbConnection, TncJdbc jdbc, AInvoiceDto dto) {
        this.jdbc = jdbc;
        this.dto = dto;
        SettingLoader settingLoader = new SettingLoader(dbConnection, jdbc.getLogin());
        this.userMidManCode = settingLoader.getMidManId();
    }

    public CustomerDto fetchCustomer(String customerCode, GetCustomerList getCustomerList) throws TncException {
        List customerList = getCustomerList.invoke(ConvertStr.buildMap(map -> map.put("code", customerCode)));
        if (customerList.isEmpty()) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        return (CustomerDto)customerList.get(0);
    }

    public MainGroupDto getMainGroup(String mGroupCode, TncJdbc jdbc) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT M_GroupCode, [SELECTED], DarsadTakhfif, PriceTakhfif,  IsNull(FromModatDate, '') fmd, IsNull(ToModatDate, '') tmd \n FROM M_GROUP WHERE M_GroupCode = ?", new Object[]{mGroupCode});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_MAIN_GROUP_ERP_CODE);
        }
        return MainGroupDto.builder().m_groupcode("M_GroupCode").selected(rs.getBoolean("SELECTED")).discountpercent(Double.valueOf(rs.getDouble("DarsadTakhfif"))).discountprice(Double.valueOf(rs.getDouble("PriceTakhfif"))).fromDueDate(Objects.requireNonNull(rs.getTimestamp("fmd")).toLocalDateTime()).toDueDate(Objects.requireNonNull(rs.getTimestamp("tmd")).toLocalDateTime()).build();
    }

    public SideGroupDto getSubGroup(String productCode, TncJdbc jdbc) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT DarsadTakhfif, PriceTakhfif,  IsNull(FromModatDate, '') fmd, IsNull(ToModatDate, '') tmd \n FROM S_GROUP  WHERE M_GroupCode = ? AND S_GroupCode = ?", new Object[]{productCode.substring(0, 2), productCode.substring(2, 4)});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_SIDE_GROUP_ERP_CODE);
        }
        return SideGroupDto.builder().discountpercent(Double.valueOf(rs.getDouble("DarsadTakhfif"))).discountprice(Double.valueOf(rs.getDouble("PriceTakhfif"))).fromDueDate(Objects.requireNonNull(rs.getTimestamp("fmd")).toLocalDateTime()).toDueDate(Objects.requireNonNull(rs.getTimestamp("tmd")).toLocalDateTime()).build();
    }

    public ProductDto getProduct(String productCode, TncJdbc jdbc) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT DarsadTakhfif, PriceTakhfif, IsNull(FromModatDate, '') fmd, IsNull(ToModatDate, '') tmd FROM ARTICLE WHERE A_CODE = ?", new Object[]{productCode});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_SIDE_GROUP_ERP_CODE);
        }
        return ProductDto.builder().fromDueDate(Objects.requireNonNull(rs.getTimestamp("fmd")).toLocalDateTime()).toDueDate(Objects.requireNonNull(rs.getTimestamp("tmd")).toLocalDateTime()).discountPercent(rs.getDouble("DarsadTakhfif")).discountPrice(rs.getDouble("PriceTakhfif")).build();
    }

    public double calcTieredDiscountCommission(CalcDiscount.TieredDiscountOrCommissionData tieredData) {
        double tieredValue = 0.0;
        double result = 0.0;
        String sql = this.getTPMasterSql(tieredData);
        SqlRowSet tpMasterRS = this.jdbc.queryForRowSet(sql);
        while (tpMasterRS.next()) {
            switch (tpMasterRS.getInt("Action_Type")) {
                case 0: {
                    tieredData.priceSum -= tieredData.originalDiscount;
                    tieredValue = this.calcWholeInvoiceDiscountCommission(tieredData, tpMasterRS);
                    break;
                }
                case 1: {
                    tieredValue = this.calcActionType1(tpMasterRS, tieredData);
                }
            }
            result += tieredValue;
        }
        tieredData.setPrevTp(result);
        return result;
    }

    private double calcWholeInvoiceDiscountCommission(CalcDiscount.TieredDiscountOrCommissionData tieredData, SqlRowSet tpMasterRS) {
        if (this.isNotInvoice(tpMasterRS) || this.isNotCustomer(tpMasterRS)) {
            return 0.0;
        }
        if (tieredData.requestType.isCommission()) {
            boolean commissionFlag;
            boolean bl = commissionFlag = ConvertStr.isNullOrEmpty((String)this.userMidManCode) || !ConvertStr.isNullOrEmpty((String)this.userMidManCode) && !this.userMidManCode.equals(tpMasterRS.getString("Vaseteh"));
            if (commissionFlag) {
                return 0.0;
            }
        }
        double result = this.calcBasedOnTpMasterTypes(tpMasterRS, tieredData);
        return result;
    }

    private double calcActionType1(SqlRowSet tpMasterRS, CalcDiscount.TieredDiscountOrCommissionData tieredData) {
        switch (tpMasterRS.getInt("TP_Type")) {
            case 3: 
            case 4: 
            case 5: {
                tieredData.amountSum = tieredData.unitAmount;
            }
        }
        tieredData.priceSum -= tieredData.originalDiscount;
        return this.calcPerRowDiscount(tieredData, tpMasterRS);
    }

    private double calcPerRowDiscount(CalcDiscount.TieredDiscountOrCommissionData data, SqlRowSet tpMasterRS) {
        if (this.isNotInvoice(tpMasterRS) || this.isNotCustomer(tpMasterRS)) {
            return 0.0;
        }
        if (!this.isMgSgArt(tpMasterRS, data)) {
            return 0.0;
        }
        if (data.getRequestType().isCommission() && !ConvertStr.isNullOrEmpty((String)this.userMidManCode) && !this.userMidManCode.equals(tpMasterRS.getString("Vaseteh"))) {
            return 0.0;
        }
        double result = this.calcBasedOnTpMasterTypes(tpMasterRS, data);
        return result;
    }

    private boolean isMgSgArt(SqlRowSet tpMasterRS, CalcDiscount.TieredDiscountOrCommissionData data) {
        boolean result = true;
        switch (tpMasterRS.getInt("ArtType")) {
            case 1: {
                if (!ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("M_Groups"))) {
                    result = this.tpMasterHasCount(tpMasterRS, "and M_Groups Like '%" + data.getProductCode().substring(0, 2) + "%'");
                }
                if (!ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("S_Groups"))) {
                    result = this.tpMasterHasCount(tpMasterRS, "and M_Groups Like '%" + data.getProductCode().substring(0, 2) + "%' and S_Groups Like'%" + data.getProductCode().substring(2, 4) + "'%");
                }
                if (ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("Articles"))) break;
                result = this.tpMasterHasCount(tpMasterRS, " and Articles Like '%" + data.getProductCode() + "%'");
                break;
            }
            case 2: {
                if (ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("Articles"))) break;
                result = this.tpMasterHasCount(tpMasterRS, " and Articles Like '%" + data.getProductCode() + "%'");
            }
        }
        return result;
    }

    private double calcBasedOnTpMasterTypes(SqlRowSet tpMasterRS, CalcDiscount.TieredDiscountOrCommissionData tieredData) {
        double result = 0.0;
        DiscountBasedOnRowDetails calc = new DiscountBasedOnRowDetails(tpMasterRS, tieredData);
        switch (tpMasterRS.getInt("TP_Type")) {
            case 0: {
                result = calc.calcGenerally();
                break;
            }
            case 1: {
                result = calc.calcBasedOnPrice();
                break;
            }
            case 2: {
                result = calc.calcBasedOnAmount();
                break;
            }
            case 3: {
                result = calc.calcBasedOnUnit();
                break;
            }
            case 4: {
                result = calc.calcBasedOnBox();
                break;
            }
            case 5: {
                result = calc.calcBasedOnPack();
            }
        }
        return result;
    }

    private boolean tpMasterHasCount(SqlRowSet tpMasterRS, @Language(value="SQL") String wherePart) {
        Integer count = (Integer)this.jdbc.queryForObject(" Select Count(*) From SetTPMaster \n Where TP_Code= '" + tpMasterRS.getString("TP_Code") + "' \n" + wherePart, Integer.class);
        return count != null && count > 0;
    }

    @NotNull
    private String getTPMasterSql(CalcDiscount.TieredDiscountOrCommissionData tieredData) {
        String sql = "SELECT M.TP_Code, Title, Calc_Type, Action_Type, TP_Type, \n ArtType, Fact_Type, M_Groups, S_Groups, Facts, Customers, Articles, \n Unit_Code, ValueFrom, ValueTo, RType, TPValue, BDate, EDate, Vaseteh \n FROM SetTPMaster M\n INNER JOIN SetTPDetail D ON D.Tp_Code = M.TP_Code \n WHERE Takhfif_Porsant = " + (tieredData.requestType.isDiscount() ? 0 : 1) + " AND Action_Type = " + tieredData.actionType + "\n";
        if (tieredData.requestType.isDiscount() && tieredData.actionType == 1) {
            sql = sql + " OR SubString(Articles, CharIndex('" + tieredData.productCode + "', Articles), 7) = '" + tieredData.productCode + "'";
        }
        return sql;
    }

    private boolean isNotInvoice(SqlRowSet tpMasterRS) {
        boolean result = true;
        if (!ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("Facts"))) {
            Integer count = (Integer)this.jdbc.queryForObject("SELECT ISNULL((Select Count(Facts) From SetTPMaster Where TP_Code = '" + tpMasterRS.getString("TP_Code") + "' and Facts Like '%" + this.dto.findAInvoiceType().getTypeChar() + "%'), 0)", Integer.class);
            result = count != null && count > 0;
        }
        return !result;
    }

    private boolean isNotCustomer(SqlRowSet tpMasterRS) {
        boolean result = true;
        if (!ConvertStr.isNullOrEmpty((String)tpMasterRS.getString("Customers"))) {
            Integer count = (Integer)this.jdbc.queryForObject("SELECT ISNULL((Select Count(Customers) From SetTPMaster Where TP_Code = '" + tpMasterRS.getString("TP_Code") + "' and Customers Like '%" + this.dto.getPartyCode() + "%'), 0)", Integer.class);
            result = count != null && count > 0;
        }
        return !result;
    }
}

